import 'dart:convert';

import 'package:get/get.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/authorization/authorization_response_model.dart';
import 'package:viserpay/data/model/auto_payment/auto_paymet_response_model.dart';
import 'package:viserpay/data/model/global/charge/charge_model.dart';
import 'package:viserpay/data/repo/auto_paymnet/auto_payment_repo.dart';

import '../../../core/utils/my_strings.dart';
import '../../../view/components/snack_bar/show_custom_snackbar.dart';
import '../../model/global/response_model/response_model.dart';

class AutoPaymentController extends GetxController {
  AutoPaymentRepo autoPaymentRepo;
  AutoPaymentController({required this.autoPaymentRepo});

  bool isLoading = true;

  String currentBalance = '0';
  AutoPaymentResponseModel? autoPaymentResponseModelData;
  GlobalCharge? sendMoneyCharge;
  List<String> otpType = [];
  String selectedOtpType = "null";

  void selectOtpType(String otpType) {
    selectedOtpType = otpType;
    update();
  }

  Future<void> initialData() async {
    isLoading = true;
    update();

    await loadAutoPaymentData();
    isLoading = false;
    update();
  }

  Future<void> loadAutoPaymentData() async {
    try {
      ResponseModel responseModel = await autoPaymentRepo.getAllAutoPaymentData();
      if (responseModel.statusCode == 200) {
        final autoPaymentResponseModel = autoPaymentResponseModelFromJson(responseModel.responseJson);
        autoPaymentResponseModelData = autoPaymentResponseModel;
        if (autoPaymentResponseModel.status.toString().toLowerCase() == MyStrings.success.toLowerCase()) {
          currentBalance = autoPaymentResponseModel.data?.currentBalance.toString() ?? "0";

          otpType.clear();
          otpType.addAll(autoPaymentResponseModel.data?.otpType?.toList() ?? []);

          update();
        } else {
          CustomSnackBar.error(errorList: autoPaymentResponseModel.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        CustomSnackBar.error(errorList: [responseModel.message]);
      }
    } catch (e) {
      printX(e);
    }

    isLoading = false;
    update();
  }

  bool isDeleteAutoPayLoading = false;

  Future<void> deleteAutoPay(String id) async {
    isDeleteAutoPayLoading = true;
    update();
    ResponseModel responseModel = await autoPaymentRepo.deleteAutoPayment(id);
    if (responseModel.statusCode == 200) {
      AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status.toString().toLowerCase() == "success") {
        Get.back(result: 'success');
        CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.requestSuccess]);
        await loadAutoPaymentData();
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.requestFail]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }
    isDeleteAutoPayLoading = false;
    update();
  }
}
